from typing import Any, List, Dict, Tuple
from .base_oracle import BaseOracle
from prompta.core.language import BaseLanguage


class DebugOracle(BaseOracle):

    def __init__(self, language: BaseLanguage, *args: Any, **kwargs: Any) -> None:
        super().__init__(language, *args, **kwargs)
        self.wrong_query_cache = kwargs.get('wrong_query_cache', {})

    def __call__(self, input_str: Tuple, *args: Any, **kwargs: Any) -> Any:
        if input_str in self.wrong_query_cache:
            return self.wrong_query_cache[input_str]
        print(input_str, self.language.in_language(input_str), self.language.context_name)
        return self.language.in_language(input_str)

    def check_conjecture(self, aut, _type=str):
        print("check")
        counterexample = self.language.counterexample(aut, _type)
        return counterexample
